<?php $total = count($reg_data);
foreach ($reg_data as $index => $booking): ?>
<div style="border:1px solid #ccc; padding:20px; margin-bottom:30px; font-family: Arial, sans-serif;">
    <h2 style="text-align: center;"><?php echo $booking['company_name']. " Registration Card"; ?></h2>
    <p style="text-align: center;">Confirmation Number: <?= $booking['booking_id']; ?></p>

    <table style="width:100%; margin-top:20px;">
        <tr>
            <td style="width:48%; vertical-align:top;">
                <strong>Customer Information</strong><br>
                <?= htmlspecialchars($booking['customer_name']); ?><br>
                <?= htmlspecialchars($booking['customer_phone']); ?><br>
                <?= htmlspecialchars($booking['customer_address']); ?><br>
                <?= htmlspecialchars($booking['customer_email']); ?><br>


                <?php if (!empty($booking['staying_customers'])): ?>
                    <?php
                        $guest_names = array_column($booking['staying_customers'], 'customer_name');
                        $other_guests = implode(', ', array_filter($guest_names));
                    ?>
                    Other Guests: <?= htmlspecialchars($other_guests); ?><br>
                <?php else: ?>
                    Other Guests:
                <?php endif; ?>

                <br><br>
                <?php foreach ($customer_fields as $field): ?>
                    <?php
                        //if ($field['show_on_registration_card'] != 1) continue;

                        $field_id = $field['id'];
                        $field_name = $field['name'];
                        $value = isset($booking['customer']['customer_fields'][$field_id])
                            ? $booking['customer']['customer_fields'][$field_id]
                            : '';
                    ?>

                    <strong><?= htmlspecialchars($field_name); ?>:</strong> ______________________ <?= htmlspecialchars($value); ?><br><br>
                <?php endforeach; ?>



            </td>

            <td style="width:48%; vertical-align:top;">
                <strong>Booking Information</strong><br>
                Room: <?= htmlspecialchars($booking['room_name']); ?><br>
                Room type: <?= htmlspecialchars($booking['room_type_name']); ?><br>
                Check-in Date: <?= date('Y-m-d', strtotime($booking['check_in_date'])); ?><br>
                Check-out Date: <?= date('Y-m-d', strtotime($booking['check_out_date'])); ?><br>
                Number of Adults: <?= $booking['adult_count']; ?><br>
                Number of Children: <?= $booking['children_count']; ?>
                <br>

                <?php $show_rate = $company['show_rate_on_registration_card']; ?>

                <?php if($show_rate == 1): ?>
                    Rate*: <?= $booking['rate'] ?? 0; ?><br>
                    Tax*: <?= number_format($booking['total_tax'] ?? 0, 2); ?><br>
                    Total*: <?= number_format($booking['charge_total'] ?? 0, 2); ?><br>

                    <?php $balance_due = $booking['balance']; ?>

                    <strong>Balance Due*:</strong> <?= number_format($balance_due ?? 0, 2); ?>
                <?php endif; ?>
            </td>
        </tr>
    </table>

    <!-- <strong>Check-in Policy:</strong> -->
    <span style="color: #555;">
        <?php echo $check_in_policies; ?>
    </span>

    <br><br><br>
    <strong>Signature(s):</strong><br><br>
    ____________________________<br><br>
    Date: _______________________
</div>

<?php if ($index < $total - 1): ?>
    <div style="page-break-after: always;"></div>
<?php endif; ?>


<?php endforeach; ?>
